/*------------------------------------------------------------------------------*
 * File Name: impwiz.h	 														*
 * Creation: Hong																*
 * Purpose: base class for filter of import file								*
 * Copyright (c) OriginLab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
 *	Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME			*
 *------------------------------------------------------------------------------*/
 
#ifndef _IMP_WIZ_
#define _IMP_WIZ_

//#include <Origin.h>

//#include "IWBase.h"// Hong 8/21/06 CLEAN_HEADER_FILE

class ImpWiz:public IWBase
{
public:
	ImpWiz():IWBase() { m_iFilterType = FILTER_TYPE_UNKNOWN; }
	~ImpWiz() {}
public:
	virtual int Execute(Layer& lyTarget, int nIndexFile, string& strFileName, TreeNode& tnInfo, TreeNode& trFilter);
protected:
/// AW 08/01/06 ADD_DATA_RANGE_IN_XF_IMPORT_FILE
	///---Sim 08-02-2006 GET_IMP_INFO_NEED_FILTER
	//virtual int GenerateImpInfo(string& strFileName, Layer& lyTarget, TreeNode& trImpInfo) 
	/// AW 08/03/06 MORE_ON_IW_IMPORT
	//virtual int GenerateImpInfo(string& strFileName, Layer& lyTarget, TreeNode& trFilter, TreeNode& trImpInfo) 
	/// Hong 04/12/07 v8.0599 ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
	//virtual void GenerateImpInfo(string& strFileName, Page& pgTarget, TreeNode& trFilter, TreeNode& trImpInfo);
	virtual void GenerateImpInfo(string& strFileName, Page& pgTarget, TreeNode& trFilter, TreeNode& trImpInfo, int& nFNodeIndex);
	/// end ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
	///---END GET_IMP_INFO_NEED_FILTER
	//	{ASSERT(FALSE); return IMPERR_IWCLASS_UNDEFINED;}
	/// END MORE_ON_IW_IMPORT
		
	/// AW 08/03/06 MORE_ON_IW_IMPORT
	virtual int GetColNumberFromFilter(TreeNode &trFilter) {ASSERT(FALSE); return 0;}
	///---Sim 08-04-06 COMMON_FUNC_ON_BASE_CLASS
	///---Sim 08-08-2006 PARTIAL_DESIGNATIOINS
	//virtual void SetColDesignations(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols);
	//virtual void SetColFormats(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols);
	virtual void SetColDesignations(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols, int nFirstSourceCol = 0);
	virtual void SetColFormats(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols, int nFirstSourceCol = 0);
	///---END PARTIAL_DESIGNATIOINS
	///---END COMMON_FUNC_ON_BASE_CLASS
	virtual int PrepareWksColsForImport(Layer &lyTarget, TreeNode &trFilter);
	///---Sim 02-26-2007 ADD_FILE_NAME_TO_COL_COMMENT
	//virtual void RenameTarget(string& strFullFileName, Layer& lyTarget, Page& pgTarget, TreeNode &trFilter );
	virtual void RenameTarget(string& strFullFileName, DataRange& drTarget, TreeNode &trFilter );
	///---END ADD_FILE_NAME_TO_COL_COMMENT
	virtual void SetPageInfo(Page& pgTarget, TreeNode &trFilter, string& strFileName);
	/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	//virtual BOOL ImportHeaderVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter);
	//virtual BOOL ImportFileNameVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter);
	virtual BOOL ImportHeaderVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter, StringArray* psaVarNiceNames = NULL);
	virtual BOOL ImportFileNameVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter, StringArray* psaVarNiceNames = NULL);
	/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	virtual void GetWksColInfo(Layer& lyTarget);
	virtual void SetWksColInfo(Page& pgTarget);
	/// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
	// virtual
	void	AfterImport(const Layer& lyTarget, LPCSTR lpszFileName, const TreeNode& trFilter, TreeNode& tnInfo);
	/// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
protected:
	void SetPageLayer(Page& pgTarget, Layer& lyTarget, TreeNode &trFilter, string& strFileName, TreeNode& trImpInfo);
	//MORE_ON_IW_IMPORT
protected:
	string 		m_strColDesig, m_strColFormat;
	bool		m_bRepetitive; ///---Sim 08-04-2006 RECORD_COL_DESIG_FORMAT_REPETITIVE
	Tree		m_trFile;
};

#endif //_IMP_WIZ_